using System;
using System.Data;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Text.RegularExpressions;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgSelectCompletedTrw
	/// </summary>
	public class DlgSelectCompletedTrw : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private DataTable _completedReactions;
		private Guid _patientTransfusionReactionGuid;
		private Guid _orderedTestGuid;
		private Common.PatientTransfusionPartialSaveId _partialSaveId;
		//
		private System.Windows.Forms.Button btnCancel;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.GroupBox grpTRW;
		private System.Windows.Forms.ListView lvTRW;
		private System.Windows.Forms.GroupBox grpSearchPOL;
		private System.Windows.Forms.DateTimePicker dtpDateEnd;
		private System.Windows.Forms.DateTimePicker dtpDateStart;
		private System.Windows.Forms.CheckBox cbDateWanted;
		private System.Windows.Forms.Button btnClear;
		private System.Windows.Forms.TextBox txtPatient;
		private System.Windows.Forms.TextBox txtSpecimen;
		private System.Windows.Forms.PictureBox pictureBox4;
		private System.Windows.Forms.Label lblSearchPatient;
		private System.Windows.Forms.Label lblSearchSpecimen;
		private System.Windows.Forms.Label lblTo;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnSearch;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.CheckBox cbIncludeNonFinalizedTRW;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.GroupBox grpDateTested;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.ColumnHeader columnHeader6;
		private System.Windows.Forms.ColumnHeader columnHeader7;
		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgSelectCompletedTrw()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();

			GetCompletedTransfusionReactions();

			SearchClick(this,EventArgs.Empty);
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgSelectCompletedTrw));
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpTRW = new System.Windows.Forms.GroupBox();
			this.lvTRW = new System.Windows.Forms.ListView();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader3 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader4 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader5 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader6 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader7 = new System.Windows.Forms.ColumnHeader();
			this.cbIncludeNonFinalizedTRW = new System.Windows.Forms.CheckBox();
			this.grpSearchPOL = new System.Windows.Forms.GroupBox();
			this.btnSearch = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.cbDateWanted = new System.Windows.Forms.CheckBox();
			this.btnClear = new System.Windows.Forms.Button();
			this.txtPatient = new System.Windows.Forms.TextBox();
			this.txtSpecimen = new System.Windows.Forms.TextBox();
			this.pictureBox4 = new System.Windows.Forms.PictureBox();
			this.lblSearchPatient = new System.Windows.Forms.Label();
			this.lblSearchSpecimen = new System.Windows.Forms.Label();
			this.grpDateTested = new System.Windows.Forms.GroupBox();
			this.dtpDateEnd = new System.Windows.Forms.DateTimePicker();
			this.dtpDateStart = new System.Windows.Forms.DateTimePicker();
			this.label1 = new System.Windows.Forms.Label();
			this.lblTo = new System.Windows.Forms.Label();
			this.grpImage.SuspendLayout();
			this.grpTRW.SuspendLayout();
			this.grpSearchPOL.SuspendLayout();
			this.grpDateTested.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(664, 30);
			this.vbecsLogo1.TabIndex = 4;
			this.vbecsLogo1.Title = "Select Transfusion Reaction Workup";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 357);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 6;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(586, 341);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 3;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.CancelClick);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 305);
			this.grpImage.TabIndex = 5;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
			this.btnOK.Location = new System.Drawing.Point(506, 341);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 2;
			this.btnOK.Click += new System.EventHandler(this.OKClick);
			this.btnOK.MouseHover += new System.EventHandler(this.OKHover);
			// 
			// grpTRW
			// 
			this.grpTRW.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpTRW.Controls.Add(this.lvTRW);
			this.grpTRW.Controls.Add(this.cbIncludeNonFinalizedTRW);
			this.grpTRW.Location = new System.Drawing.Point(60, 100);
			this.grpTRW.Name = "grpTRW";
			this.grpTRW.Size = new System.Drawing.Size(600, 236);
			this.grpTRW.TabIndex = 1;
			this.grpTRW.TabStop = false;
			this.grpTRW.Text = "Search Results";
			// 
			// lvTRW
			// 
			this.lvTRW.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvTRW.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																					this.columnHeader1,
																					this.columnHeader2,
																					this.columnHeader3,
																					this.columnHeader4,
																					this.columnHeader5,
																					this.columnHeader6,
																					this.columnHeader7});
			this.lvTRW.FullRowSelect = true;
			this.lvTRW.HideSelection = false;
			this.lvTRW.Location = new System.Drawing.Point(8, 16);
			this.lvTRW.MultiSelect = false;
			this.lvTRW.Name = "lvTRW";
			this.lvTRW.Size = new System.Drawing.Size(582, 200);
			this.lvTRW.TabIndex = 0;
			this.lvTRW.View = System.Windows.Forms.View.Details;
			this.lvTRW.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.ColumnClick);
			this.lvTRW.SelectedIndexChanged += new System.EventHandler(this.ReactionSelected);
			// 
			// columnHeader1
			// 
			this.columnHeader1.Text = "Patient Name";
			this.columnHeader1.Width = 74;
			// 
			// columnHeader2
			// 
			this.columnHeader2.Text = "Patient ID";
			this.columnHeader2.Width = 56;
			// 
			// columnHeader3
			// 
			this.columnHeader3.Text = "Pre-Specimen UID";
			this.columnHeader3.Width = 98;
			// 
			// columnHeader4
			// 
			this.columnHeader4.Text = "Post-Specimen UID";
			this.columnHeader4.Width = 103;
			// 
			// columnHeader5
			// 
			this.columnHeader5.Text = "Date Completed";
			this.columnHeader5.Width = 87;
			// 
			// columnHeader6
			// 
			this.columnHeader6.Text = "Reaction Type";
			this.columnHeader6.Width = 81;
			// 
			// columnHeader7
			// 
			this.columnHeader7.Text = "Date Finalized";
			this.columnHeader7.Width = 79;
			// 
			// cbIncludeNonFinalizedTRW
			// 
			this.cbIncludeNonFinalizedTRW.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.cbIncludeNonFinalizedTRW.Location = new System.Drawing.Point(8, 216);
			this.cbIncludeNonFinalizedTRW.Name = "cbIncludeNonFinalizedTRW";
			this.cbIncludeNonFinalizedTRW.Size = new System.Drawing.Size(208, 16);
			this.cbIncludeNonFinalizedTRW.TabIndex = 1;
			this.cbIncludeNonFinalizedTRW.Text = "Include &Non-Finalized TRW Reports";
			this.cbIncludeNonFinalizedTRW.CheckedChanged += new System.EventHandler(this.SearchClick);
			// 
			// grpSearchPOL
			// 
			this.grpSearchPOL.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSearchPOL.Controls.Add(this.btnSearch);
			this.grpSearchPOL.Controls.Add(this.cbDateWanted);
			this.grpSearchPOL.Controls.Add(this.btnClear);
			this.grpSearchPOL.Controls.Add(this.txtPatient);
			this.grpSearchPOL.Controls.Add(this.txtSpecimen);
			this.grpSearchPOL.Controls.Add(this.pictureBox4);
			this.grpSearchPOL.Controls.Add(this.lblSearchPatient);
			this.grpSearchPOL.Controls.Add(this.lblSearchSpecimen);
			this.grpSearchPOL.Controls.Add(this.grpDateTested);
			this.grpSearchPOL.Location = new System.Drawing.Point(60, 32);
			this.grpSearchPOL.Name = "grpSearchPOL";
			this.grpSearchPOL.Size = new System.Drawing.Size(600, 68);
			this.grpSearchPOL.TabIndex = 0;
			this.grpSearchPOL.TabStop = false;
			this.grpSearchPOL.Text = "Search Criteria";
			// 
			// btnSearch
			// 
			this.btnSearch.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSearch.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnSearch.Image = ((System.Drawing.Image)(resources.GetObject("btnSearch.Image")));
			this.btnSearch.Location = new System.Drawing.Point(516, 12);
			this.btnSearch.Name = "btnSearch";
			this.btnSearch.Size = new System.Drawing.Size(75, 23);
			this.btnSearch.TabIndex = 6;
			this.btnSearch.Click += new System.EventHandler(this.SearchClick);
			// 
			// cbDateWanted
			// 
			this.cbDateWanted.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.cbDateWanted.Location = new System.Drawing.Point(260, 8);
			this.cbDateWanted.Name = "cbDateWanted";
			this.cbDateWanted.Size = new System.Drawing.Size(116, 20);
			this.cbDateWanted.TabIndex = 4;
			this.cbDateWanted.Text = "&Date Completed";
			this.cbDateWanted.CheckedChanged += new System.EventHandler(this.DateWantedChecked);
			// 
			// btnClear
			// 
			this.btnClear.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnClear.Location = new System.Drawing.Point(516, 40);
			this.btnClear.Name = "btnClear";
			this.btnClear.TabIndex = 7;
			this.btnClear.Text = "C&lear";
			this.btnClear.Click += new System.EventHandler(this.ClearClick);
			// 
			// txtPatient
			// 
			this.txtPatient.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtPatient.Location = new System.Drawing.Point(104, 40);
			this.txtPatient.MaxLength = 30;
			this.txtPatient.Name = "txtPatient";
			this.txtPatient.Size = new System.Drawing.Size(124, 20);
			this.txtPatient.TabIndex = 3;
			this.txtPatient.Text = "";
			// 
			// txtSpecimen
			// 
			this.txtSpecimen.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSpecimen.Location = new System.Drawing.Point(104, 16);
			this.txtSpecimen.MaxLength = 15;
			this.txtSpecimen.Name = "txtSpecimen";
			this.txtSpecimen.Size = new System.Drawing.Size(124, 20);
			this.txtSpecimen.TabIndex = 1;
			this.txtSpecimen.Text = "";
			// 
			// pictureBox4
			// 
			this.pictureBox4.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox4.Image")));
			this.pictureBox4.Location = new System.Drawing.Point(10, 20);
			this.pictureBox4.Name = "pictureBox4";
			this.pictureBox4.Size = new System.Drawing.Size(20, 20);
			this.pictureBox4.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox4.TabIndex = 56;
			this.pictureBox4.TabStop = false;
			// 
			// lblSearchPatient
			// 
			this.lblSearchPatient.Location = new System.Drawing.Point(32, 40);
			this.lblSearchPatient.Name = "lblSearchPatient";
			this.lblSearchPatient.Size = new System.Drawing.Size(76, 20);
			this.lblSearchPatient.TabIndex = 2;
			this.lblSearchPatient.Text = "Patient";
			this.lblSearchPatient.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblSearchSpecimen
			// 
			this.lblSearchSpecimen.Location = new System.Drawing.Point(32, 16);
			this.lblSearchSpecimen.Name = "lblSearchSpecimen";
			this.lblSearchSpecimen.Size = new System.Drawing.Size(80, 23);
			this.lblSearchSpecimen.TabIndex = 0;
			this.lblSearchSpecimen.Text = "Specimen UID";
			this.lblSearchSpecimen.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpDateTested
			// 
			this.grpDateTested.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.grpDateTested.Controls.Add(this.dtpDateEnd);
			this.grpDateTested.Controls.Add(this.dtpDateStart);
			this.grpDateTested.Controls.Add(this.label1);
			this.grpDateTested.Controls.Add(this.lblTo);
			this.grpDateTested.Location = new System.Drawing.Point(252, 12);
			this.grpDateTested.Name = "grpDateTested";
			this.grpDateTested.Size = new System.Drawing.Size(240, 48);
			this.grpDateTested.TabIndex = 5;
			this.grpDateTested.TabStop = false;
			// 
			// dtpDateEnd
			// 
			this.dtpDateEnd.CustomFormat = "MM/dd/yyyy";
			this.dtpDateEnd.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpDateEnd.Location = new System.Drawing.Point(144, 16);
			this.dtpDateEnd.Name = "dtpDateEnd";
			this.dtpDateEnd.Size = new System.Drawing.Size(80, 20);
			this.dtpDateEnd.TabIndex = 3;
			// 
			// dtpDateStart
			// 
			this.dtpDateStart.CustomFormat = "MM/dd/yyyy";
			this.dtpDateStart.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpDateStart.Location = new System.Drawing.Point(40, 16);
			this.dtpDateStart.Name = "dtpDateStart";
			this.dtpDateStart.Size = new System.Drawing.Size(80, 20);
			this.dtpDateStart.TabIndex = 1;
			this.dtpDateStart.Value = new System.DateTime(2003, 5, 22, 0, 0, 0, 0);
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(32, 20);
			this.label1.TabIndex = 0;
			this.label1.Text = "From";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblTo
			// 
			this.lblTo.Location = new System.Drawing.Point(128, 16);
			this.lblTo.Name = "lblTo";
			this.lblTo.Size = new System.Drawing.Size(20, 20);
			this.lblTo.TabIndex = 2;
			this.lblTo.Text = "To";
			this.lblTo.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// DlgSelectCompletedTrw
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(664, 373);
			this.Controls.Add(this.grpSearchPOL);
			this.Controls.Add(this.grpTRW);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.btnOK);
			this.hlphelpChm.SetHelpKeyword(this, "Finalize_Print_TRW.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(650, 400);
			this.Name = "DlgSelectCompletedTrw";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Select Transfusion Reaction Workup";
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpTRW, 0);
			this.Controls.SetChildIndex(this.grpSearchPOL, 0);
			this.grpImage.ResumeLayout(false);
			this.grpTRW.ResumeLayout(false);
			this.grpSearchPOL.ResumeLayout(false);
			this.grpDateTested.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Get PatientTransfusionReactionGuid
		/// </summary>
		public Guid PatientTransfusionReactionGuid
		{
			get
			{
				return this._patientTransfusionReactionGuid;
			}
		}

		/// <summary>
		/// Get OrderedTestGuid
		/// </summary>
		public Guid OrderedTestGuid
		{
			get
			{
				return this._orderedTestGuid;
			}
		}

		/// <summary>
		/// Get PartialSaveId
		/// </summary>
		public Common.PatientTransfusionPartialSaveId PartialSaveId
		{
			get
			{
				return this._partialSaveId;
			}
		}

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC078.DlgSelectCompletedTrw());
			//
			this.btnSearch.Text = "&Search";
			this.btnSearch.EnabledButton = true;
			//
			this.btnOK.Text = "&OK";
			this.btnOK.EnabledButton = false;
			//
			this.ClearSearchCriteria();
			//
			this.cbIncludeNonFinalizedTRW.Checked = false;
			this.cbIncludeNonFinalizedTRW.Enabled = (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.PrintInternalReports));
			//
			this.btnSearch.SetToolTip(Common.StrRes.Tooltips.Common.SearchFor().ResString);
			this.SetThisToolTip(this.btnClear,Common.StrRes.Tooltips.Common.ClearEntries());
			this.SetThisToolTip(this.btnCancel, Common.StrRes.Tooltips.Common.Cancel());
		}

		private void ClearSearchCriteria()
		{
			this.txtPatient.Text = "";
			this.txtSpecimen.Text = "";
			//
			this.cbDateWanted.Checked = false;
			this.DateWantedChecked(this,EventArgs.Empty);
		}

		private void GetCompletedTransfusionReactions()
		{
			_completedReactions = BOL.PatientTransfusionReaction.GetCompletedPatientTransfusionReactions();
			//
		}

		private void AddRowToListView(DataRow dr)
		{
			ListViewItem lvi = new ListViewItem();
			lvi.Tag = dr;
			lvi.Text = BOL.Patient.BuildDisplayName(dr[Common.VbecsTables.Patient.PatientFirstName].ToString(),dr[Common.VbecsTables.Patient.PatientMiddleName].ToString(),dr[Common.VbecsTables.Patient.PatientLastName].ToString());
			lvi.SubItems.Add(dr[Common.VbecsTables.Patient.DisplayVistaPatientId].ToString());
			if (Convert.ToBoolean(dr[Common.VbecsTables.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator]))
			{
				lvi.SubItems.Add("Not available");
			}
			else
			{
				lvi.SubItems.Add(dr["PreSpecimenUid"].ToString());
			}
			if (Convert.ToBoolean(dr[Common.VbecsTables.PatientTransfusionReaction.PostSpecimenNotAvailableIndicator]))
			{
				lvi.SubItems.Add("Not available");
			}
			else
			{
				lvi.SubItems.Add(dr["PostSpecimenUid"].ToString());
			}
			lvi.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(dr["CompletedDateTime"]));
			if (Convert.ToInt32(dr[Common.VbecsTables.PatientTransfusionReaction.PartialSaveId]) == 5)
			{
				lvi.SubItems.Add(dr[Common.VbecsTables.TransfusionReactionType.TransfusionReactionTypeText].ToString());
				lvi.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(dr["FinalizedDateTime"]));
			}
			else
			{
				//Add empty string, otherwise the column click sorter will fail!
				lvi.SubItems.Add("");
				lvi.SubItems.Add("");
			}
			this.lvTRW.Items.Add(lvi);
		}

		private void AddNoResultsFoundToListView()
		{
			this.lvTRW.Items.Add(new ListViewItem("No transfusion reactions to display"));
		}

		private void ClearClick(object sender, System.EventArgs e)
		{
			this.ClearSearchCriteria();
		}

		private void DateWantedChecked(object sender, System.EventArgs e)
		{
			if (this.cbDateWanted.Checked)
			{
				this.grpDateTested.Enabled = true;
				//
				this.dtpDateStart.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime().Date;
				this.dtpDateStart.CustomFormat = Common.VBECSDateTime.DateFormat;
				this.dtpDateEnd.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime().Date;
				this.dtpDateEnd.CustomFormat = Common.VBECSDateTime.DateFormat;

			}
			else
			{
				this.grpDateTested.Enabled = false;
				//
				this.dtpDateStart.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime().Date;
				this.dtpDateStart.CustomFormat = " ";
				this.dtpDateEnd.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime().Date;
				this.dtpDateEnd.CustomFormat = " ";
			}
		}

		private string BuildSearchString()
		{
			string selectStr = "";
			//
			if (!cbIncludeNonFinalizedTRW.Checked)
			{
				selectStr += Common.VbecsTables.PatientTransfusionReaction.PartialSaveId + " = 5 ";
			}
			if (cbDateWanted.Checked)
			{
				selectStr += "AND CompletedDateTime >= '" + this.dtpDateStart.Value.ToShortDateString() + "' AND CompletedDateTime <= '" + Common.VBECSDateTime.FormatDateTimeString(this.dtpDateEnd.Value.Date.AddHours(23).AddMinutes(59).AddSeconds(59)) + "' ";
			}
			if (this.txtSpecimen.Text.Trim().Length>0)
			{
				selectStr += "AND PreSpecimenUid = '" + this.txtSpecimen.Text.Trim() + "' OR PostSpecimenUid = '" + this.txtSpecimen.Text.Trim() + "' ";
			}
			if (this.txtPatient.Text.Trim().Length>0)
			{
				Regex initialLastFour = Common.RegularExpressions.PatientInitialAndLastFourSSN();
				Regex ssn = Common.RegularExpressions.PatientSsn();
				Regex name = Common.RegularExpressions.PatientName();
				Regex lastFour = Common.RegularExpressions.LastFourSSN();
				//
				if (initialLastFour.IsMatch(this.txtPatient.Text.ToUpper().Trim()))
				{
					selectStr += "AND "+Common.VbecsTables.Patient.PatientLastName+" LIKE '" + this.txtPatient.Text.ToUpper()[0].ToString() + "%' AND "+Common.VbecsTables.Patient.PatientSsn+" LIKE '%" + this.txtPatient.Text.Trim().Substring(1) + "'";
				}
				else if (lastFour.IsMatch(this.txtPatient.Text.Trim()))
				{
					selectStr += "AND "+Common.VbecsTables.Patient.PatientSsn+" LIKE '%" + this.txtPatient.Text.Trim() + "'";
				}
				else if (ssn.IsMatch(this.txtPatient.Text.Trim().Replace("-","")))
				{
					selectStr += "AND "+Common.VbecsTables.Patient.PatientSsn+" = '" + this.txtPatient.Text.Trim() + "'";
				}
				else if (name.IsMatch(this.txtPatient.Text.ToUpper().Trim()))
				{
					selectStr += "AND "+Common.VbecsTables.Patient.PatientLastName+" LIKE '" + this.txtPatient.Text.ToUpper() + "%'";
				}
				else
				{
					selectStr += "AND "+Common.VbecsTables.Patient.PatientLastName+" IS NULL";
				}
			}
			//
			if (selectStr.StartsWith("AND "))
			{
				selectStr = selectStr.Substring(4);
			}
			//
			return selectStr;
		}

		private void SearchClick(object sender, System.EventArgs e)
		{
			this.lvTRW.Items.Clear();
			//
			DataRow[] drMatch = _completedReactions.Select(this.BuildSearchString());
			//
			if ((drMatch != null) && (drMatch.Length > 0))
			{
				foreach(DataRow dr in drMatch)
				{
					this.AddRowToListView(dr);
				}
			}
			else
			{
				this.AddNoResultsFoundToListView();
			}
			//
			controls.VbecsFunction.SetColumnWidths(this.lvTRW);
		}

		private void ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if ((e.Column == 4) || (e.Column == 6))
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender,e,lvTRW.CheckBoxes,controls.ColumnClickSorter.ColumnSortType.DateTime);
			}
			else
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender,e,lvTRW.CheckBoxes,controls.ColumnClickSorter.ColumnSortType.String);
			}
		}

		private void ReactionSelected(object sender, System.EventArgs e)
		{
			if (this.lvTRW.SelectedItems.Count>0)
			{
				if (this.lvTRW.SelectedItems[0].Tag == null)
				{
					this._patientTransfusionReactionGuid = Guid.Empty;
					this._orderedTestGuid = Guid.Empty;
					this.btnOK.EnabledButton = false;
				}
				else
				{
					DataRow dr = (DataRow)this.lvTRW.SelectedItems[0].Tag;
					this._patientTransfusionReactionGuid = (Guid)dr[Common.VbecsTables.PatientTransfusionReaction.PatientTransfusionReactionGuid];
					this._orderedTestGuid = (Guid)dr[Common.VbecsTables.PatientTransfusionReaction.OrderedTestGuid];
					this._partialSaveId = (Common.PatientTransfusionPartialSaveId)Convert.ToInt32(dr[Common.VbecsTables.PatientTransfusionReaction.PartialSaveId]);
					this.btnOK.EnabledButton = true;
				}
			}
			else
			{
				this._patientTransfusionReactionGuid = Guid.Empty;
				this.btnOK.EnabledButton = false;
			}
		}

		private void CancelClick(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}

		private void OKClick(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.OK;
			this.Close();
		}

		private void OKHover(object sender, System.EventArgs e)
		{
			if (this._patientTransfusionReactionGuid == Guid.Empty)
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.SelectOneItem("patient transfusion reaction workup").ResString);
			}
			else
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
			}
		}

	}
}

